<?php
/*
 * Plugin Name: Options for Twenty Twenty-One
 * Version: 1.2.2
 * Description: Adds various options to modify the default Wordpress theme Twenty Twenty-One
 * Author: Webd Ltd
 * Author URI: https://webd.uk
 * Text Domain: options-for-twenty-twenty-one
 */



if (!defined('ABSPATH')) {
    exit('This isn\'t the page you\'re looking for. Move along, move along.');
}



if (!class_exists('options_for_twenty_twenty_one_class')) {

	class options_for_twenty_twenty_one_class {

        public static $version = '1.2.2';

		function __construct() {

            add_action('customize_register', array($this, 'oftto_customize_register'), 999);
            add_action('widgets_init', array($this, 'oftto_widgets_init'), 11);
            add_action('customize_preview_init', array($this, 'oftto_enqueue_customize_preview_js'));

            if (is_admin()) {

                add_action('after_setup_theme', array($this, 'oftto_editor_styles'), 11);
                add_filter('pre_http_request', array($this, 'oftto_pre_http_request'), 10, 3);
                add_action('customize_controls_enqueue_scripts', array($this, 'oftto_enqueue_customizer_css'));
                add_action('customize_controls_enqueue_scripts', array($this, 'oftto_enqueue_customize_controls_js'));

                add_filter('plugin_action_links_' . plugin_basename(__FILE__), array($this, 'oftto_add_plugin_action_links'));
                add_action('admin_notices', 'ofttoCommon::admin_notices');
                add_action('wp_ajax_dismiss_oftto_notice_handler', 'ofttoCommon::ajax_notice_handler');
                add_action('customize_controls_enqueue_scripts', 'ofttoCommon::enqueue_customize_controls_js');

            } else {

                add_action('wp_head', array($this, 'oftto_frontend_styles'));
                add_action('wp_footer', array($this, 'oftto_frontend_javascript'));

            }

            add_action('customize_register', 'webd_customize_register');

		}

		function oftto_add_plugin_action_links($links) {

			$settings_links = ofttoCommon::plugin_action_links(admin_url('customize.php'));

			return array_merge($settings_links, $links);

		}

        function oftto_customize_register($wp_customize) {

            $section_description = ofttoCommon::control_section_description();
            $upgrade_nag = ofttoCommon::control_setting_upgrade_nag();



            $wp_customize->add_section('oftto_general', array(
                'title'     => __('General Options', 'options-for-twenty-twenty-one'),
                'description'  => __('Use these options to customise the overall site design.', 'options-for-twenty-twenty-one') . ' ' . $section_description,
                'priority'     => 0
            ));



            $wp_customize->add_setting('body_font_size', array(
                'default'           => 1250,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('body_font_size', array(
                'label'         => __('Body Font Size', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the font size of regular text.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_general',
                'settings'      => 'body_font_size',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 625,
                    'max'   => 2500,
                    'step'  => 25
                )
            ));

            $wp_customize->add_setting('remove_link_underlines', array(
                'default'       => false,
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('remove_link_underlines', array(
                'label'         => __('Remove Link Underlines', 'options-for-twenty-twenty-one'),
                'description'   => __('Remove the underlines shown under links throughout the site.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_general',
                'settings'      => 'remove_link_underlines',
                'type'          => 'checkbox'
            ));

            $sidebar_locations = array(
                'all' => __('Everywhere', 'options-for-twenty-twenty-one'),
                'front_page' => __('Front Page', 'options-for-twenty-twenty-one'),
                'home' => __('Main Blog Page', 'options-for-twenty-twenty-one'),
                'page' => __('Single Pages', 'options-for-twenty-twenty-one'),
                'single' => __('Single Posts', 'options-for-twenty-twenty-one'),
                'archive' => __('Archive Pages', 'options-for-twenty-twenty-one')
            );

            foreach(get_post_types(array('public' => 'true')) as $post_type) {

                $post_type_object = get_post_type_object($post_type);
                $sidebar_locations['post_type/' . $post_type] = __('Post Type: ', 'options-for-twenty-twenty-one') . $post_type_object->label;

                foreach (get_object_taxonomies($post_type, 'objects') as $taxonomy) {

                    if ($taxonomy->name !== 'post_format') {

                        $sidebar_locations['taxonomy/' . $post_type . '/' . $taxonomy->name] = $post_type_object->label . __(' Taxonomy: ', 'options-for-twenty-twenty-one') . $taxonomy->label;

                    }

                }

            }

            $wp_customize->add_setting('inject_sidebar', array(
                'default'       => array(),
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_multiple_options'
            ));
            $wp_customize->add_control(new webd_Customize_Control_Checkbox_Multiple($wp_customize, 'inject_sidebar', array(
                'label'         => __('Inject Sidebar', 'options-for-twenty-twenty-one'),
                'description'   => __('Inject a sidebar into the theme by choosing where you want it shown. Remember, you\'ll need to add widgets to the sidebar for it to show!', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_general',
                'settings'      => 'inject_sidebar',
                'choices'       => $sidebar_locations
            )));

            $wp_customize->add_setting('aligndefault_max_width', array(
                'default'           => 610,
                'transport'         => 'refresh',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('aligndefault_max_width', array(
                'label'         => __('Align Default Max Width', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the maximum width of align default content.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_general',
                'settings'      => 'aligndefault_max_width',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 382,
                    'max'   => 1040,
                    'step'  => 2
                )
            ));

            $wp_customize->add_setting('alignwide_max_width', array(
                'default'           => 1240,
                'transport'         => 'refresh',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('alignwide_max_width', array(
                'label'         => __('Align Wide Max Width', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the maximum width of align wide content.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_general',
                'settings'      => 'alignwide_max_width',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 622,
                    'max'   => 1240,
                    'step'  => 2
                )
            ));

            $taxonomies = array(
                'blog' => 'Posts / Blog Page'
            );

            foreach(get_taxonomies(array('public' => 'true'), 'objects') as $taxonomy) {

                $taxonomies[$taxonomy->name] = __('Taxonomy: ', 'options-for-twenty-twenty-one') . ': ' . $taxonomy->label;

            }

            unset($taxonomies['post_format']);

            $wp_customize->add_setting('archive_grid_template', array(
                'default'       => array(),
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_multiple_options'
            ));
            $wp_customize->add_control(new webd_Customize_Control_Checkbox_Multiple($wp_customize, 'archive_grid_template', array(
                'label'         => __('Archive Grid Template', 'options-for-twenty-twenty-one'),
                'description'   => __('Show posts in a grid format on taxonomy pages.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_general',
                'settings'      => 'archive_grid_template',
                'choices'       => $taxonomies
            )));



            $wp_customize->add_section('oftto_header', array(
                'title'     => __('Header Options', 'options-for-twenty-twenty-one'),
                'description'  => __('Use these options to customise the header.', 'options-for-twenty-twenty-one') . ' ' . $section_description,
                'priority'     => 0
            ));



            $wp_customize->add_setting('hide_site_header', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_site_header', array(
                'label'         => __('Hide Site Header', 'options-for-twenty-twenty-one'),
                'description'   => __('Hide the site\'s header including site title, description, logo and navigation.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'hide_site_header',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('wide_site_header', array(
                'default'       => false,
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('wide_site_header', array(
                'label'         => __('Wide Site Header', 'options-for-twenty-twenty-one'),
                'description'   => __('Full width site header.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'wide_site_header',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('header_background_image', array(
                'default'           => false,
                'transport'         => 'refresh',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control(new WP_Customize_Media_Control($wp_customize, 'header_background_image', array(
                'mime_type'     => 'image',
                'label'         => __('Header Background Image', 'options-for-twenty-twenty-one'),
                'description'   => __('Choose an image to use in the header background.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'header_background_image'
            )));

            $wp_customize->add_setting('header_min_height', array(
                'default'           => 0,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('header_min_height', array(
                'label'         => __('Homepage Header Min Height', 'options-for-twenty-twenty-one'),
                'description'   => __('Choose the minimum height of the site header on the home page.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'header_min_height',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 0,
                    'max'   => 100,
                    'step'  => 5
                )
            ));

            $wp_customize->add_setting('site_wide_header_height', array(
                'default'       => false,
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('site_wide_header_height', array(
                'label'         => __('Site Wide Header Height', 'options-for-twenty-twenty-one'),
                'description'   => __('Set the min height of the header on all pages, not just the home page.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'site_wide_header_height',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('header_padding_top', array(
                'default'           => 73,
                'transport'         => 'refresh',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('header_padding_top', array(
                'label'         => __('Header Padding Top', 'options-for-twenty-twenty-one'),
                'description'   => __('Reduce the padding above the header.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'header_padding_top',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 1,
                    'max'   => 73,
                    'step'  => 1
                )
            ));

            $wp_customize->add_setting('header_padding_bottom', array(
                'default'           => 91,
                'transport'         => 'refresh',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('header_padding_bottom', array(
                'label'         => __('Header Padding Bottom', 'options-for-twenty-twenty-one'),
                'description'   => __('Reduce the padding below the header.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'header_padding_bottom',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 1,
                    'max'   => 91,
                    'step'  => 1
                )
            ));

            $wp_customize->add_setting('logo_size', array(
                'default'           => 100,
                'transport'         => 'refresh',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('logo_size', array(
                'label'         => __('Logo Size', 'options-for-twenty-twenty-one'),
                'description'   => __('Chaange the maximum width of the site logo.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'logo_size',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 100,
                    'max'   => 1240,
                    'step'  => 10
                )
            ));

            $wp_customize->add_setting('logo_align', array(
                'default'       => '',
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_options'
            ));
            $wp_customize->add_control('logo_align', array(
                'label'         => __('Logo Align', 'options-for-twenty-twenty-one'),
                'description'   => __('Align the logo in the header.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'logo_align',
                'type'          => 'select',
                'choices'       => array(
                    'left' => __('Left', 'options-for-twenty-twenty-one'),
                    '' => __('Center', 'options-for-twenty-twenty-one'),
                    'right' => __('Right', 'options-for-twenty-twenty-one')
                ),
                'active_callback' => array($this, 'oftto_are_title_and_tagline_displayed')
            ));

            $wp_customize->add_setting('hide_site_title', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_site_title', array(
                'label'         => __('Hide Site Title', 'options-for-twenty-twenty-one'),
                'description'   => __('Hide the site title in the header.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'hide_site_title',
                'type'          => 'checkbox',
                'active_callback' => array($this, 'oftto_are_title_and_tagline_displayed')
            ));

            $wp_customize->add_setting('site_title_align', array(
                'default'       => '',
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_options'
            ));
            $wp_customize->add_control('site_title_align', array(
                'label'         => __('Site Title Align', 'options-for-twenty-twenty-one'),
                'description'   => __('Align the site title in the header.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'site_title_align',
                'type'          => 'select',
                'choices'       => array(
                    '' => __('Left', 'options-for-twenty-twenty-one'),
                    'center' => __('Center', 'options-for-twenty-twenty-one'),
                    'right' => __('Right', 'options-for-twenty-twenty-one')
                ),
                'active_callback' => array($this, 'oftto_are_title_and_tagline_displayed')
            ));

            $wp_customize->add_setting('site_title_color', array(
                'default'       => '',
                'transport'     => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));
            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'site_title_color', array(
                'label'         => __('Site Title Color', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the color of the site title.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
            	'settings'      => 'site_title_color',
                'active_callback' => array($this, 'oftto_are_title_and_tagline_displayed')
            )));

            $wp_customize->add_setting('site_title_font_size', array(
                'default'           => 1500,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('site_title_font_size', array(
                'label'         => __('Site Title Font Size', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the font size of the site title.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'site_title_font_size',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 750,
                    'max'   => 3000,
                    'step'  => 25
                ),
                'active_callback' => array($this, 'oftto_are_title_and_tagline_displayed')
            ));

            $wp_customize->add_setting('site_title_text_transform', array(
                'default'       => '',
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_options'
            ));
            $wp_customize->add_control('site_title_text_transform', array(
                'label'         => __('Site Title Font Case', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the font case of the site title.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'site_title_text_transform',
                'type'          => 'select',
                'choices'       => array(
                    'none' => __('None', 'options-for-twenty-twenty-one'),
                    'capitalize' => __('Capitalise', 'options-for-twenty-twenty-one'),
                    '' => __('Uppercase', 'options-for-twenty-twenty-one'),
                    'lowercase' => __('Lowercase', 'options-for-twenty-twenty-one')
                )
            ));

            $wp_customize->add_setting('hide_site_description', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_site_description', array(
                'label'         => __('Hide Site Description', 'options-for-twenty-twenty-one'),
                'description'   => __('Hide the site description in the header.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'hide_site_description',
                'type'          => 'checkbox',
                'active_callback' => array($this, 'oftto_are_title_and_tagline_displayed')
            ));

            $wp_customize->add_setting('site_description_align', array(
                'default'       => '',
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_options'
            ));
            $wp_customize->add_control('site_description_align', array(
                'label'         => __('Site Description Align', 'options-for-twenty-twenty-one'),
                'description'   => __('Align the site description in the header.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'site_description_align',
                'type'          => 'select',
                'choices'       => array(
                    '' => __('Left', 'options-for-twenty-twenty-one'),
                    'center' => __('Center', 'options-for-twenty-twenty-one'),
                    'right' => __('Right', 'options-for-twenty-twenty-one')
                ),
                'active_callback' => array($this, 'oftto_are_title_and_tagline_displayed')
            ));

            $wp_customize->add_setting('site_description_color', array(
                'default'       => '',
                'transport'     => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));
            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'site_description_color', array(
                'label'         => __('Site Description Color', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the color of the site description.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
            	'settings'      => 'site_description_color',
                'active_callback' => array($this, 'oftto_are_title_and_tagline_displayed')
            )));

            $wp_customize->add_setting('site_description_font_size', array(
                'default'           => 1125,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('site_description_font_size', array(
                'label'         => __('Site Description Font Size', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the font size of the site description.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_header',
                'settings'      => 'site_description_font_size',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 560,
                    'max'   => 2250,
                    'step'  => 25
                ),
                'active_callback' => array($this, 'oftto_are_title_and_tagline_displayed')
            ));



            $wp_customize->add_section('oftto_navigation', array(
                'title'     => __('Nav Options', 'options-for-twenty-twenty-one'),
                'description'  => __('Use these options to customise the navigation.', 'options-for-twenty-twenty-one') . ' ' . $section_description,
                'priority'     => 0
            ));



            $wp_customize->add_setting('mobile_nav_on_desktop', array(
                'default'       => false,
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('mobile_nav_on_desktop', array(
                'label'         => __('Mobile Nav on Desktop', 'options-for-twenty-twenty-one'),
                'description'   => __('Show the mobile navigation hamburger menu on all screen sizes.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_navigation',
                'settings'      => 'mobile_nav_on_desktop',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('mobile_nav_align', array(
                'default'       => '',
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_options'
            ));
            $wp_customize->add_control('mobile_nav_align', array(
                'label'         => __('Mobile Nav Align', 'options-for-twenty-twenty-one'),
                'description'   => __('Align the navigation on small screens.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_navigation',
                'settings'      => 'mobile_nav_align',
                'type'          => 'select',
                'choices'       => array(
                    '' => __('None', 'options-for-twenty-twenty-one'),
                    'left' => __('Left', 'options-for-twenty-twenty-one'),
                    'center' => __('Center', 'options-for-twenty-twenty-one'),
                    'right' => __('Right', 'options-for-twenty-twenty-one')
                ),
                'active_callback' => array($this, 'oftto_are_title_and_tagline_displayed')
            ));

            $wp_customize->add_setting('desktop_nav_align', array(
                'default'       => '',
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_options'
            ));
            $wp_customize->add_control('desktop_nav_align', array(
                'label'         => __('Desktop Nav Align', 'options-for-twenty-twenty-one'),
                'description'   => __('Align the navigation on larger screens.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_navigation',
                'settings'      => 'desktop_nav_align',
                'type'          => 'select',
                'choices'       => array(
                    '' => __('None', 'options-for-twenty-twenty-one'),
                    'left' => __('Left', 'options-for-twenty-twenty-one'),
                    'center' => __('Center', 'options-for-twenty-twenty-one'),
                    'right' => __('Right', 'options-for-twenty-twenty-one')
                )
            ));

            $wp_customize->add_setting('hide_mobile_menu_text', array(
                'default'       => false,
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_mobile_menu_text', array(
                'label'         => __('Hide Mobile Menu Text', 'options-for-twenty-twenty-one'),
                'description'   => __('Hide the word "Menu" next to the hamburger menu on smaller screens.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_navigation',
                'settings'      => 'hide_mobile_menu_text',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('nav_burger_icon_size', array(
                'default'           => 24,
                'transport'         => 'refresh',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('nav_burger_icon_size', array(
                'label'         => __('Nav Burger Icon Size', 'options-for-twenty-twenty-one'),
                'description'   => __('Increase the size of the hamburger icon on the mobile navigation button on larger screens.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_navigation',
                'settings'      => 'nav_burger_icon_size',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 24,
                    'max'   => 96,
                    'step'  => 4
                )
            ));

            $wp_customize->add_setting('nav_link_color', array(
                'default'       => '',
                'transport'     => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));
            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'nav_link_color', array(
                'label'         => __('Nav Link Color', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the color of the navigation links.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_navigation',
            	'settings'      => 'nav_link_color'
            )));

            $wp_customize->add_setting('nav_link_hover_color', array(
                'default'       => '',
                'transport'     => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));
            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'nav_link_hover_color', array(
                'label'         => __('Nav Link Color', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the color of the navigation hover links.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_navigation',
            	'settings'      => 'nav_link_hover_color'
            )));

            $wp_customize->add_setting('nav_desktop_font_size', array(
                'default'           => 1250,
                'transport'         => 'refresh',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('nav_desktop_font_size', array(
                'label'         => __('Nav Desktop Font Size', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the font size of the navigation on larger screens.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_navigation',
                'settings'      => 'nav_desktop_font_size',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 625,
                    'max'   => 2500,
                    'step'  => 25
                )
            ));

            $wp_customize->add_setting('nav_font_weight', array(
                'default'           => 400,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('nav_font_weight', array(
                'label'         => __('Nav Font Weight', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the font weight of the navigation.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_navigation',
                'settings'      => 'nav_font_weight',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 100,
                    'max'   => 900,
                    'step'  => 100
                )
            ));



            $wp_customize->add_section('oftto_content', array(
                'title'     => __('Content Options', 'options-for-twenty-twenty-one'),
                'description'  => __('Use these options to customise the content.', 'options-for-twenty-twenty-one') . ' ' . $section_description,
                'priority'     => 0
            ));



            $wp_customize->add_setting('hide_page_headers', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_page_headers', array(
                'label'         => __('Hide Headers', 'options-for-twenty-twenty-one'),
                'description'   => __('Hides the header on single posts and pages which includes the title and featured image.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'hide_page_headers',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('hide_page_titles', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_page_titles', array(
                'label'         => __('Hide Titles', 'options-for-twenty-twenty-one'),
                'description'   => __('Hides the titles on single posts and pages.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'hide_page_titles',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('hide_featured_images', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_featured_images', array(
                'label'         => __('Hide Featured Images', 'options-for-twenty-twenty-one'),
                'description'   => __('Hides the featured images on single posts and pages.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'hide_featured_images',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('page_title_font_size', array(
                'default'           => 4000,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('page_title_font_size', array(
                'label'         => __('Page Title Font Size', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the font size of page and post titles.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'page_title_font_size',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 2000,
                    'max'   => 8000,
                    'step'  => 50
                )
            ));

            $wp_customize->add_setting('hide_archive_titles', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_archive_titles', array(
                'label'         => __('Hide Archive Titles', 'options-for-twenty-twenty-one'),
                'description'   => __('Hides the titles on category and tag pages.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'hide_archive_titles',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('archive_title_font_size', array(
                'default'           => 4000,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('archive_title_font_size', array(
                'label'         => __('Archive Title Font Size', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the font size of tag and category archive titles.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'archive_title_font_size',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 2000,
                    'max'   => 8000,
                    'step'  => 50
                )
            ));

            $wp_customize->add_setting('page_title_letter_spacing', array(
                'default'           => 0,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('page_title_letter_spacing', array(
                'label'         => __('Page Title Letter Spacing', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the letter spacing of page titles.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'page_title_letter_spacing',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 0,
                    'max'   => 20,
                    'step'  => 1
                )
            ));

            $wp_customize->add_setting('hide_date', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_date', array(
                'label'         => __('Hide Date', 'options-for-twenty-twenty-one'),
                'description'   => __('Hide the date from posts and archive pages.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'hide_date',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('move_date', array(
                'default'       => false,
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('move_date', array(
                'label'         => __('Move Date', 'options-for-twenty-twenty-one'),
                'description'   => __('Move the "Published" date below the post title on single posts.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'move_date',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('remove_author', array(
                'default'       => false,
                'transport'     => 'refresh',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('remove_author', array(
                'label'         => __('Remove Author', 'options-for-twenty-twenty-one'),
                'description'   => __('Prevents Twenty Twenty-One from revealing the author of a post.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'remove_author',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('hide_taxonomies', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_taxonomies', array(
                'label'         => __('Hide Taxonomies', 'options-for-twenty-twenty-one'),
                'description'   => __('Hide element that contains tags and categories from posts and archive pages.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'hide_taxonomies',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('hide_tags', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_tags', array(
                'label'         => __('Hide Tags', 'options-for-twenty-twenty-one'),
                'description'   => __('Hide tag links from posts and archive pages.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'hide_tags',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('hide_cat', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_cat', array(
                'label'         => __('Hide Categories', 'options-for-twenty-twenty-one'),
                'description'   => __('Hide category links from posts and archive pages.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'hide_cat',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('hide_post_navigation', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_post_navigation', array(
                'label'         => __('Hide Post Navigation', 'options-for-twenty-twenty-one'),
                'description'   => __('Hide previous and next post links on single posts.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_content',
                'settings'      => 'hide_post_navigation',
                'type'          => 'checkbox'
            ));



            $wp_customize->add_section('oftto_footer', array(
                'title'     => __('Footer Options', 'options-for-twenty-twenty-one'),
                'description'  => __('Use these options to customise the footer.', 'options-for-twenty-twenty-one') . ' ' . $section_description,
                'priority'     => 0
            ));



            $wp_customize->add_setting('footer_margin_top', array(
                'default'           => 181,
                'transport'         => 'refresh',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('footer_margin_top', array(
                'label'         => __('Footer Margin Top', 'options-for-twenty-twenty-one'),
                'description'   => __('Reduce the margin above the footer widgets.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_footer',
                'settings'      => 'footer_margin_top',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 1,
                    'max'   => 181,
                    'step'  => 5
                )
            ));

            $wp_customize->add_setting('footer_border_top', array(
                'default'           => 4,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('footer_border_top', array(
                'label'         => __('Footer Border Top', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the width of the border above the site info in the footer.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_footer',
                'settings'      => 'footer_border_top',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 1,
                    'max'   => 11,
                    'step'  => 1
                )
            ));

            $wp_customize->add_setting('footer_widget_font_size', array(
                'default'           => 1125,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('footer_widget_font_size', array(
                'label'         => __('Widget Area Font Size', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the font size of the widget area.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_footer',
                'settings'      => 'footer_widget_font_size',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 560,
                    'max'   => 2250,
                    'step'  => 25
                )
            ));

            $wp_customize->add_setting('social_icon_color', array(
                'default'       => '',
                'transport'     => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));
            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'social_icon_color', array(
                'label'         => __('Social Icon Color', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the default color of the social icons.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_footer',
            	'settings'      => 'social_icon_color'
            )));

            $wp_customize->add_setting('hide_site_info', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('hide_site_info', array(
                'label'         => __('Hide Site Info', 'options-for-twenty-twenty-one'),
                'description'   => __('Hides the site logo or title and the border above it in the website footer.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_footer',
                'settings'      => 'hide_site_info',
                'type'          => 'checkbox'
            ));

            $wp_customize->add_setting('footer_border_top', array(
                'default'           => 4,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'absint'
            ));
            $wp_customize->add_control('footer_border_top', array(
                'label'         => __('Footer Border Top', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the width of the border above the site info in the footer.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_footer',
                'settings'      => 'footer_border_top',
                'type'          => 'range',
                'input_attrs' => array(
                    'min'   => 1,
                    'max'   => 11,
                    'step'  => 1
                )
            ));

            $wp_customize->add_setting('footer_site_title_text_transform', array(
                'default'       => '',
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_options'
            ));
            $wp_customize->add_control('footer_site_title_text_transform', array(
                'label'         => __('Footer Site Title Font Case', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the font case of the site title in the footer.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_footer',
                'settings'      => 'footer_site_title_text_transform',
                'type'          => 'select',
                'choices'       => array(
                    'none' => __('None', 'options-for-twenty-twenty-one'),
                    'capitalize' => __('Capitalise', 'options-for-twenty-twenty-one'),
                    '' => __('Uppercase', 'options-for-twenty-twenty-one'),
                    'lowercase' => __('Lowercase', 'options-for-twenty-twenty-one')
                )
            ));

            $wp_customize->add_setting('remove_powered_by_wordpress', array(
                'default'       => false,
                'transport'     => 'postMessage',
                'sanitize_callback' => 'ofttoCommon::sanitize_boolean'
            ));
            $wp_customize->add_control('remove_powered_by_wordpress', array(
                'label'         => __('Hide Powered by WordPress', 'options-for-twenty-twenty-one'),
                'description'   => __('Hides the "Powered by WordPress" text displayed in the website footer.', 'options-for-twenty-twenty-one'),
                'section'       => 'oftto_footer',
                'settings'      => 'remove_powered_by_wordpress',
                'type'          => 'checkbox'
            ));



            $wp_customize->add_setting('__global__color_primary', array(
                'default'       => '',
                'transport'     => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));
            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, '__global__color_primary', array(
                'label'         => __('Primary Color', 'options-for-twenty-twenty-one'),
                'description'   => __('Change the primary color.', 'options-for-twenty-twenty-one'),
                'section'       => 'colors',
            	'settings'      => '__global__color_primary'
            )));



            $control_label = __('Featured Background Image', 'options-for-twenty-twenty-one');
            $control_description = __('Use the featured image as the background image (where applicable).', 'options-for-twenty-twenty-one');
            ofttoCommon::add_hidden_control($wp_customize, 'featured_background_image', 'oftto_general', $control_label, $control_description . ' ' . $upgrade_nag);

            $control_label = __('Featured Header Image', 'options-for-twenty-twenty-one');
            $control_description = __('Use the featured image as the header image (where applicable).', 'options-for-twenty-twenty-one');
            ofttoCommon::add_hidden_control($wp_customize, 'featured_header_image', 'oftto_header', $control_label, $control_description . ' ' . $upgrade_nag);

            $control_label = __('Mobile Nav Breakpoint', 'options-for-twenty-twenty-one');
            $control_description = __('Choose when to show the mobile navigation hamburger menu on larger screen sizes.', 'options-for-twenty-twenty-one');
            ofttoCommon::add_hidden_control($wp_customize, 'mobile_nav_breakpoint', 'oftto_navigation', $control_label, $control_description . ' ' . $upgrade_nag);

            $control_label = __('Sticky Nav on Mobile', 'options-for-twenty-twenty-one');
            $control_description = __('Fix the navigation bar to the top of the screen on small screens.', 'options-for-twenty-twenty-one');
            ofttoCommon::add_hidden_control($wp_customize, 'sticky_nav_on_mobile', 'oftto_navigation', $control_label, $control_description . ' ' . $upgrade_nag);

            $control_label = __('Sticky Nav on Desktop', 'options-for-twenty-twenty-one');
            $control_description = __('Fix the navigation bar to the top of the screen on larger screens.', 'options-for-twenty-twenty-one');
            ofttoCommon::add_hidden_control($wp_customize, 'sticky_nav_on_desktop', 'oftto_navigation', $control_label, $control_description . ' ' . $upgrade_nag);

            $control_label = __('Social Links Icon Size', 'options-for-twenty-twenty-one');
            $control_description = __('Increase the size of the social link icons on larger screens.', 'options-for-twenty-twenty-one');
            ofttoCommon::add_hidden_control($wp_customize, 'social_links_icon_size', 'oftto_footer', $control_label, $control_description . ' ' . $upgrade_nag);

            $control_label = __('Fix Social Links', 'options-for-twenty-twenty-one');
            $control_description = __('Fix the social links to the left or right for large screens.', 'options-for-twenty-twenty-one');
            ofttoCommon::add_hidden_control($wp_customize, 'fix_social_links', 'oftto_footer', $control_label, $control_description . ' ' . $upgrade_nag);

            $control_label = __('Add Icons and Colors to Social Links Menu', 'options-for-twenty-twenty-one');
            $control_description = __('Adds the Linkedin social icon and changes the color of the social icons to their relevant corporate colors.', 'options-for-twenty-twenty-one');
            ofttoCommon::add_hidden_control($wp_customize, 'colored_social_links_menu', 'oftto_footer', $control_label, $control_description . ' ' . $upgrade_nag);

            $control_label = __('Replace "Powered by" Text', 'options-for-twenty-twenty-one');
            $control_description = __('Provide alternate text to replace "Proudly powered by Wordpress".', 'options-for-twenty-twenty-one');
            ofttoCommon::add_hidden_control($wp_customize, 'replace_powered_by_wordpress', 'oftto_footer', $control_label, $control_description . ' ' . $upgrade_nag);

        }

        function oftto_frontend_styles() {

            $mod = absint((get_theme_mod('mobile_nav_breakpoint')));
            $mobile_breakpoint = ($mod ? $mod + 481 : 481);

?>
<!--Customizer CSS-->
<style type="text/css">
<?php

            $mod = get_theme_mod('__global__font_size_base');

            if ($mod) {

                set_theme_mod('body_font_size', $mod);
                remove_theme_mod('__global__font_size_base');

            }

            $mod = get_theme_mod('__global__font_size_lg');

            if ($mod) {

                set_theme_mod('site_title_font_size', $mod);
                remove_theme_mod('__global__font_size_lg');

            }

            $mod = get_theme_mod('site_title_desktop_font_size');

            if ($mod) {

                set_theme_mod('site_title_font_size', $mod);
                remove_theme_mod('site_title_desktop_font_size');

            }

            $mod = get_theme_mod('__branding__title__text_transform');

            if ($mod) {

                set_theme_mod('site_title_text_transform', $mod);
                remove_theme_mod('__branding__title__text_transform');

            }

            $mod = get_theme_mod('__global__font_size_sm');

            if ($mod) {

                set_theme_mod('site_description_font_size', $mod);
                set_theme_mod('footer_widget_font_size', $mod);
                remove_theme_mod('__global__font_size_sm');

            }

            $mod = get_theme_mod('__global__font_size_md');

            if ($mod) {

                set_theme_mod('nav_desktop_font_size', $mod);
                remove_theme_mod('__global__font_size_md');

            }

            $mod = get_theme_mod('__primary_nav__font_weight');

            if ($mod) {

                set_theme_mod('nav_font_weight', $mod);
                remove_theme_mod('__primary_nav__font_weight');

            }

            $mod = get_theme_mod('__global__font_size_xxl');

            if ($mod) {

                set_theme_mod('page_title_font_size', $mod);
                remove_theme_mod('__global__font_size_xxl');

            }

            $mod = get_theme_mod('__global__letter_spacing');

            if ($mod) {

                set_theme_mod('page_title_letter_spacing', $mod);
                remove_theme_mod('__global__letter_spacing');

            }

            ofttoCommon::generate_css('body', 'font-size', 'body_font_size', '', 'rem', absint(get_theme_mod('body_font_size')) / 1000);
            ofttoCommon::generate_css('a', 'text-decoration', 'remove_link_underlines', '', '', 'none');
            ofttoCommon::generate_css(':root', '--global--color-primary', '__global__color_primary');
            ofttoCommon::generate_css(':root', '--global--color-secondary', '__global__color_primary');
            ofttoCommon::generate_css(':root', '--button--color-background', '__global__color_primary');
            ofttoCommon::generate_css(':root', '--button--color-text-hover', '__global__color_primary');

            if (get_theme_mod('inject_sidebar') || ((is_single() || is_page()) && get_post_meta(get_the_ID(), 'oftto_show_sidebar', true) == '1')) {

?>
@media (min-width: 482px) {
    #content-wrapper {
        display: flex;
    }
    #content-wrapper>#content {
        width: 67%;
    }
    #content-wrapper>#sidebar {
        width: 33%;
    }
}
#sidebar {
    display: block;
    margin-top: 0;
    padding: 0 30px;
}
<?php

            }

            $mod = absint(get_theme_mod('aligndefault_max_width'));

            if ($mod) {
?>
@media only screen and (min-width: 482px) {
	:root {
		--responsive--aligndefault-width: min(calc(100vw - 4 * var(--global--spacing-horizontal)), <?= $mod; ?>px);
	}
}
@media only screen and (min-width: 822px) {
	:root {
		--responsive--aligndefault-width: min(calc(100vw - 8 * var(--global--spacing-horizontal)), <?= $mod; ?>px);
	}
}
<?php
            }

            $mod = absint(get_theme_mod('alignwide_max_width'));

            if ($mod) {
?>
@media only screen and (min-width: 822px) {
	:root {
		--responsive--alignwide-width: min(calc(100vw - 8 * var(--global--spacing-horizontal)), <?= $mod; ?>px);
	}
}
<?php
            }

            $mod = get_theme_mod('archive_grid_template');

            if ($mod && is_array($mod)) {

                foreach ($mod as $taxonomy) {

                    switch ($taxonomy) {

                        case 'blog':

                            break;

                        case 'category':

                            break;

                        case 'post_tag':

                            $taxonomy = 'tag';
                            break;

                        default:

                            $taxonomy = 'tax-' . $taxonomy;
                            break;

                    }

?>
.<?= $taxonomy; ?> .site-main {
	display: flex;
	flex-wrap: wrap;
	padding-left: 0;
	padding-right: 0;
	width: 100%;
}
@media (min-width: 482px) {
	.<?= $taxonomy; ?> .site-main {
        padding-left: 1rem;
        padding-right: 1rem;
    }
}
.<?= $taxonomy; ?> .site-main>* {
	padding: 1rem;
	width: 100%;
}
.<?= $taxonomy; ?> .site-main>article {
	margin: 0;
}
@media (min-width: 482px) {
	.<?= $taxonomy; ?> .site-main>article {
        width: 50%;
    }
}
@media (min-width: 822px) {
	.<?= $taxonomy; ?> .site-main>article {
        width: 25%;
    }
}
.<?= $taxonomy; ?> .site-main>article>.entry-header {
	width: 100%;
	position: relative;
	margin: 0;
}
.<?= $taxonomy; ?> .site-main>article:not(.has-post-thumbnail)>.entry-header {
	border: 1px solid #28303d;
}
.<?= $taxonomy; ?> .site-main>article>.entry-header::after {
	display: block;
	content: '';
	padding-bottom: 65%;
}
.<?= $taxonomy; ?> .site-main>article>.entry-header>.entry-title {
	display: flex;
	position: absolute;
	z-index: 2;
	height: 100%;
	width: 100%;
	font-size: 1.3rem;
	text-align: center;
	justify-content: center;
	flex-direction: column;
	padding: 0 1rem;
}
.<?= $taxonomy; ?> .site-main>article>.entry-header>.entry-title>a {
	text-decoration: none;
	text-transform: uppercase;
	font-weight: 900;
}
.<?= $taxonomy; ?> .site-main>article.has-post-thumbnail>.entry-header>.entry-title>a {
	color: white;
	text-shadow: -1px -1px 0 #28303d, 1px -1px 0 #28303d, -1px 1px 0 #28303d, 1px 1px 0 #28303d;
}
.<?= $taxonomy; ?> .site-main>article>.entry-header>.post-thumbnail {
	margin: 0;
}
.<?= $taxonomy; ?> .site-main>article>.entry-header>.post-thumbnail img {
	position: absolute;
	width: 100% !important;
	height: 100% !important;
	object-fit: cover;
	margin: 0;
	z-index: 1;
}
.<?= $taxonomy; ?> .site-main>article>.entry-footer,
.<?= $taxonomy; ?> .site-main>article>.entry-content {
	display: none;
}
<?php

                }

            }

            $mod = absint(get_theme_mod('header_min_height'));

            if ($mod) {

?>
<?= (get_theme_mod('site_wide_header_height') ? '' : '.home '); ?>#masthead {
	min-height: <?= $mod; ?>vh;
}
<?= (get_theme_mod('site_wide_header_height') ? '' : '.home'); ?>.admin-bar #masthead {
	min-height: calc(<?= $mod; ?>vh - 32px);
}
@media screen and (max-width: 782px) {
    <?= (get_theme_mod('site_wide_header_height') ? '' : '.home'); ?>.admin-bar #masthead {
    	min-height: calc(<?= $mod; ?>vh - 46px);
    }
}
<?php

            }

            ofttoCommon::generate_css('.site-header', 'display', 'hide_site_header', '', '', 'none');

            if (get_theme_mod('wide_site_header')) {
?>
.site-header {
max-width: calc(100vw -  30px);
}
@media only screen and (min-width: 482px) {
.site-header {
max-width: calc(100vw -  38px);
}
}
<?php
            }

            $mod = absint(get_theme_mod('header_background_image'));

            if ($mod) {
?>
#masthead-wrapper {
	background-image: url("<?= (wp_get_attachment_image_src($mod, 'full') ? wp_get_attachment_image_src($mod, 'full')[0] : ''); ?>");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
}
@supports (-webkit-touch-callout: none) {
    #masthead-wrapper {
        background-attachment: scroll;
    }
}
<?php
            }

            $mod = absint(get_theme_mod('header_padding_top'));

            if ($mod) {

                $mod = $mod - 1;

?>
.site-header {
    padding-top: 74px;
}
@media only screen and (min-width: 482px) {
    .site-header {
        padding-top: <?= round($mod * 40 / 72, 1); ?>px;
    }
}
@media only screen and (min-width: 822px) {
    .site-header {
        padding-top: <?= $mod; ?>px;
    }
}
<?php
            }

            $mod = absint(get_theme_mod('header_padding_bottom'));

            if ($mod) {

                $mod = $mod - 1;

?>
.site-header {
    padding-bottom: <?= round($mod * 60 / 90, 1); ?>px;
}
@media only screen and (min-width: 482px) {
    .site-header {
        padding-bottom: <?= round($mod * 40 / 90, 1); ?>px;
    }
}
@media only screen and (min-width: 822px) {
    .site-header {
        padding-bottom: <?= $mod; ?>px;
    }
}
<?php
            }

            $mod = absint(get_theme_mod('logo_size'));

            if ($mod) {

?>
.site-logo .custom-logo {
    max-width: <?= $mod; ?>px;
    max-height: none;
    width: 100%;
}
@media only screen and (max-width: 481px) {
    .site-header.has-logo:not(.has-title-and-tagline).has-menu .site-logo img {
        width: auto;
    }
}
<?php

            }

            ofttoCommon::generate_css('.site-header > .site-logo', 'text-align', 'logo_align');
            ofttoCommon::generate_css('.site-title', 'display', 'hide_site_title', '', '', 'none');
            ofttoCommon::generate_css('.site-title', 'text-align', 'site_title_align');
            ofttoCommon::generate_css('.site-title', 'color', 'site_title_color');

            $mod = absint(get_theme_mod('site_title_font_size'));

            if ($mod) {
?>
.site-title {
    font-size: <?= $mod / 1000; ?>rem;
}
<?php
            }

            ofttoCommon::generate_css('.site-title, .site-footer > .site-info .site-name', 'text-transform', 'site_title_text_transform');
            ofttoCommon::generate_css('.site-description', 'display', 'hide_site_description', '', '', 'none');
            ofttoCommon::generate_css('.site-description', 'text-align', 'site_description_align');
            ofttoCommon::generate_css('.site-description', 'color', 'site_description_color');
            ofttoCommon::generate_css('.site-description', 'font-size', 'site_description_font_size', '', 'rem', absint(get_theme_mod('site_description_font_size')) / 1000);

            if (get_theme_mod('mobile_nav_on_desktop')) {

                if (!$this->oftto_are_title_and_tagline_displayed()) {

?>
@media only screen and (min-width: 482px) {
    .site-header {
        position: relative;
    }
    .primary-navigation {
        position: absolute;
        right: -15px;
    }
}
<?php

                }

?>
.primary-navigation-open .primary-navigation {
    z-index: 2;
}
.primary-navigation-open .primary-navigation > .primary-menu-container {
    height: 100vh;
    overflow-x: hidden;
    overflow-y: auto;
    border: 2px solid transparent;
}
.primary-navigation > div > .menu-wrapper {
    padding-bottom: 100px;
    padding-left: 0;
}
.primary-navigation-open .primary-navigation {
    width: 100%;
    position: fixed;
}
.menu-button-container {
    display: block;
}
.primary-navigation > .primary-menu-container {
    visibility: hidden;
    opacity: 0;
    position: fixed;
    padding-top: 71px;
    padding-left: 20px;
    padding-right: 20px;
    padding-bottom: 25px;
    background-color: <?= (get_theme_mod('background_color') ? '#' . get_theme_mod('background_color') : '#d1e4dd'); ?>;
    transition: all 0.15s ease-in-out;
    transform: translateX(0) translateY(0);
}
.primary-navigation > div > .menu-wrapper li {
    display: block;
    position: relative;
    width: 100%;
}
body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline .menu-button-container #primary-mobile-menu {
	padding-left: calc(var(--global--spacing-horizontal) * 0.6 - 4.5px);
	padding-right: calc(var(--global--spacing-horizontal) * 0.6 - 4.5px);
	margin-right: calc(0px - var(--global--spacing-horizontal) * 0.6);
}
.has-logo.has-title-and-tagline .primary-navigation > .primary-menu-container {
    position: fixed;
    transform: translateY(0) translateX(100%);
}
body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline .menu-button-container {
    position: relative;
    padding-top: 0;
    margin-top: calc(0px - var(--button--padding-vertical)) + (0.25 * var(--global--spacing-unit))));
}
body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline .primary-navigation {
    position: relative;
    top: 0;
}
.primary-navigation-open .has-logo.has-title-and-tagline .primary-navigation > .primary-menu-container {
    transform: translateX(0) translateY(0);
}
.admin-bar .primary-navigation {
	top:32px;
}
@media screen and (max-width: 782px) {
    .admin-bar .primary-navigation {
    	top: 46px;
    }
}
.primary-navigation-open .menu-button-container {
    width: auto;
}
<?php

            }

            $mod = get_theme_mod('mobile_nav_align');

            if ($mod) {
?>
@media only screen and (max-width: <?= $mobile_breakpoint; ?>px) {
<?php

                if ($mod === 'left') {

?>
    .primary-navigation {
        margin-left: 0;
        margin-right: auto;
    }
    body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline .menu-button-container #primary-mobile-menu {
        margin-left: -10.5px;
    }
<?php

                } elseif ($mod === 'center') {

?>
    .primary-navigation {
        margin-left: auto;
        margin-right: auto;
    }
    body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline .menu-button-container #primary-mobile-menu {
        margin-right: 0;
    }
<?php

                } elseif ($mod === 'right') {

?>
    .primary-navigation {
        margin-left: auto;
        margin-right: 0;
    }
<?php

                }

?>
}
<?php
            }

            $mod = get_theme_mod('desktop_nav_align');

            if ($mod) {
?>
@media only screen and (min-width: <?= $mobile_breakpoint + 1; ?>px) {
<?php

                if ($mod === 'left') {

?>
    .primary-navigation {
        margin-left: 0;
        margin-right: auto;
    }
    body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline .menu-button-container #primary-mobile-menu {
        margin-left: -10.5px;
    }
<?php

                } elseif ($mod === 'center') {

?>
    .primary-navigation {
        margin-left: auto;
        margin-right: auto;
    }
    body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline .menu-button-container #primary-mobile-menu {
        margin-right: 0;
    }
<?php

                } elseif ($mod === 'right') {

?>
    .primary-navigation {
        margin-left: auto;
        margin-right: 0;
    }
<?php

                }

?>
}
<?php
            }

            if (get_theme_mod('hide_mobile_menu_text')) {
?>
.menu-button-container .button.button .dropdown-icon {
	text-indent: -99999px;
	white-space: nowrap;
	overflow: hidden;
}
<?php
            }

            $mod = absint(get_theme_mod('nav_burger_icon_size'));

            if ($mod) {
?>
@media only screen and (min-width: 482px) {
.menu-button-container .button.button .dropdown-icon.open .svg-icon {
width: <?= (($mod - 24) / 2) + 24; ?>px;
height: <?= (($mod - 24) / 2) + 24; ?>px;
}
}
@media only screen and (min-width: 822px) {
.menu-button-container .button.button .dropdown-icon.open .svg-icon {
width: <?= $mod; ?>px;
height: <?= $mod; ?>px;
}
}
<?php
            }

            ofttoCommon::generate_css('.primary-navigation a:link, .primary-navigation a:visited', 'color', 'nav_link_color');
            ofttoCommon::generate_css('.primary-navigation a:hover', 'color', 'nav_link_hover_color');

            $mod = absint(get_theme_mod('nav_desktop_font_size'));

            if ($mod) {
?>
@media only screen and (min-width: <?= $mobile_breakpoint + 1; ?>px) {
	.primary-navigation a {
		font-size: <?= $mod / 1000; ?>rem;
	}
}
<?php
            }

            ofttoCommon::generate_css('.primary-navigation a', 'font-weight', 'nav_font_weight');

            ofttoCommon::generate_css('.entry-header', 'display', 'hide_page_headers', '', '', 'none');
            ofttoCommon::generate_css('.entry-title', 'display', 'hide_page_titles', '', '', 'none');
            ofttoCommon::generate_css('.page .entry-header .post-thumbnail, .single .entry-header .post-thumbnail', 'display', 'hide_featured_images', '', '', 'none');
            ofttoCommon::generate_css('.singular .entry-title, .error404 .page-title', 'font-size', 'page_title_font_size', '', 'rem', absint(get_theme_mod('page_title_font_size')) / 1000);
            ofttoCommon::generate_css('.archive .page-header', 'display', 'hide_archive_titles', '', '', 'none');
            ofttoCommon::generate_css('.archive .page-title, .search .page-title', 'font-size', 'archive_title_font_size', '', 'rem', absint(get_theme_mod('archive_title_font_size')) / 1000);
            ofttoCommon::generate_css('.entry-title, .page-title', 'letter-spacing', 'page_title_letter_spacing', '', 'em', absint(get_theme_mod('page_title_letter_spacing')) / 100);
            ofttoCommon::generate_css('.post-taxonomies', 'display', 'hide_taxonomies', '', '', 'none');
            ofttoCommon::generate_css('.tags-links', 'display', 'hide_tags', '', '', 'none');
            ofttoCommon::generate_css('.archive .entry-footer .cat-links, .single .site-main>article>.entry-footer .cat-links', 'display', 'hide_cat', '', '', 'none');
            ofttoCommon::generate_css('.posted-on', 'display', 'hide_date', '', '', 'none');
            ofttoCommon::generate_css('.post-navigation', 'display', 'hide_post_navigation', '', '', 'none');

            if (get_theme_mod('remove_author')) {

                add_filter('gettext', array($this, 'oftto_replace_post_author_text'), 10, 3);

?>
.single .site-main > article > .entry-footer .byline {
	display: none;
}
<?php

            }

            $mod = absint(get_theme_mod('footer_margin_top'));

            if ($mod) {
?>
.widget-area, .no-widgets .site-footer {
	margin-top: <?= $mod -1; ?>px;
}
@media only screen and (max-width: 481px) {
	.widget-area {
		margin-top: <?= ceil(($mod -1) / 2); ?>px;
	}
}
<?php
            }

            ofttoCommon::generate_css('.widget-area', 'font-size', 'footer_widget_font_size', '', 'rem', absint(get_theme_mod('footer_widget_font_size')) / 1000);
            ofttoCommon::generate_css('.footer-navigation-wrapper li .svg-icon', 'fill', 'social_icon_color');
            ofttoCommon::generate_css('.site-footer>.site-info', 'border-top-width', 'footer_border_top', '', 'px', absint(get_theme_mod('footer_border_top')) - 1);
            ofttoCommon::generate_css('.site-footer>.site-info', 'display', 'hide_site_info', '', '', 'none');
            ofttoCommon::generate_css('.site-footer > .site-info .site-name', 'text-transform', 'footer_site_title_text_transform');
            ofttoCommon::generate_css('.powered-by', 'display', 'remove_powered_by_wordpress', '', '', 'none');

?>
</style> 
<!--/Customizer CSS-->
<?php

        }

        function oftto_editor_styles() {

        	add_editor_style('https://options-for-twenty-twenty-one/style-editor.css');

        }

        function oftto_pre_http_request($response, $parsed_args, $url) {

        	if ($url === 'https://options-for-twenty-twenty-one/style-editor.css') {

        		$response = array(
        			'body'     => '',
        			'headers'  => new Requests_Utility_CaseInsensitiveDictionary(),
        			'response' => array(
        				'code'    => 200,
        				'message' => 'OK',    
				    ),
                    'cookies'  => array(),
                    'filename' => null,
		        );

                if (get_theme_mod('body_font_size')) { $response['body'] .= 'body { font-size: ' . (get_theme_mod('body_font_size') / 1000) . 'rem; }'; }
                if (get_theme_mod('page_title_font_size')) { $response['body'] .= '.wp-block.editor-post-title__block .editor-post-title__input { font-size: ' . (get_theme_mod('page_title_font_size') / 1000) . 'rem; }'; }
                if (get_theme_mod('page_title_letter_spacing')) { $response['body'] .= '.wp-block.editor-post-title__block .editor-post-title__input { letter-spacing: ' . (get_theme_mod('page_title_letter_spacing') / 100) . 'em; }'; }

        	}

        	return $response;

        }

        function oftto_enqueue_customize_preview_js() {

            wp_enqueue_script('oftto-customize-preview', plugin_dir_url( __FILE__ ) . 'js/customize-preview.js', array('jquery','customize-preview'), self::$version, true);

        }

        function oftto_enqueue_customize_controls_js() {

            wp_enqueue_script('oftn-customize-controls', plugin_dir_url(__FILE__) . 'js/customize-controls.js', array('jquery', 'customize-controls'), ofttoCommon::plugin_version(), true);


        }

        function oftto_enqueue_customizer_css() {

            wp_enqueue_style('oftto-customizer-css', plugin_dir_url( __FILE__ ) . 'css/theme-customizer.css', array(), self::$version);

        }

        public function oftto_replace_post_author_text($translation, $text, $domain) {
 
            if ($text === 'By %s' && $domain == 'twentytwentyone') {

                $translation = '';

            }

            return $translation;

        }

        public function oftto_frontend_javascript() {

            $inject_sidebar_args = get_theme_mod('inject_sidebar');

            if ($inject_sidebar_args || ((is_single() || is_page()) && get_post_meta(get_the_ID(), 'oftto_show_sidebar', true) == '1')) {

                if (is_archive()) {

                    global $wp_query;
                    $taxonomy = $wp_query->get_queried_object();

                }

                if (
                    is_active_sidebar('sidebar-2') && (
                        in_array('all', $inject_sidebar_args) ||
                        (in_array('front_page', $inject_sidebar_args) && is_front_page()) ||
                        (in_array('home', $inject_sidebar_args) && is_home()) ||
                        (in_array('page', $inject_sidebar_args) && is_page()) ||
                        (in_array('single', $inject_sidebar_args) && is_single()) ||
                        (in_array('archive', $inject_sidebar_args) && is_archive()) ||
                        (is_single() && in_array('post_type/' . get_post_type() , $inject_sidebar_args)) ||
                        (is_page() && !is_front_page() && in_array('post_type/page', $inject_sidebar_args)) ||
                        (is_archive() && in_array('taxonomy/' . get_post_type() . '/' . $taxonomy->taxonomy , $inject_sidebar_args)) ||
                        ((is_single() || is_page()) && get_post_meta(get_the_ID(), 'oftto_show_sidebar', true) == '1')
                    )
                ) {

?>
<aside id="sidebar" class="widget-area">
<?php dynamic_sidebar('sidebar-2'); ?>
</aside>
<script type="text/javascript">
    (function () {
        var wrapper = document.createElement('div'),
            content,
            sidebar = document.getElementById('sidebar');
        content = document.getElementById('content');
        wrapper.id = 'content-wrapper';
        wrapper.className += 'alignwide';
        content.parentNode.insertBefore(wrapper, content);
        wrapper.appendChild(content);
        wrapper.appendChild(sidebar);
<?php

                    if (is_archive()) {

?>
        document.body.insertBefore(document.getElementsByClassName('archive-header')[0], document.getElementById('site-content-wrapper'));
<?php

                    }

?>
    }());
</script>
<?php

                }

            }

            $mod = absint(get_theme_mod('header_background_image'));

            if ($mod) {

?>
<script type="text/javascript">
    (function () {
    	var masthead = document.querySelector('#masthead');
        var mastheadWrapper = document.createElement('div');
        mastheadWrapper.id = 'masthead-wrapper';
        masthead.parentNode.insertBefore(mastheadWrapper, masthead);
        mastheadWrapper.appendChild(masthead);
    }());
</script>
<?php

            }

            if (is_single() && get_theme_mod('move_date')) {

?>
<script type="text/javascript">
    (function () {
    	var posted_on = document.querySelector('.posted-on');
    	var posted_on_div = document.createElement('div');
        posted_on_div.className += 'posted-on';
        posted_on_div.innerHTML = posted_on.innerHTML;
        var entry_header = document.querySelector('.entry-header');
        entry_header.appendChild(posted_on_div);
        posted_on.parentNode.removeChild(posted_on);
    }());
</script>
<?php

            }

        }

        function oftto_widgets_init() {

            register_sidebar(array(
                'name'          => esc_html__('Sidebar', 'options-for-twenty-twenty-one'),
                'id'            => 'sidebar-2',
                'description'   => esc_html__('Add widgets here to appear in your sidebar.', 'options-for-twenty-twenty-one'),
                'before_title'  => '<h2 class="widget-title">',
                'after_title'   => '</h2>',
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget'  => '</section>'
            ));

        }

        public function oftto_are_title_and_tagline_displayed() {

            return (get_theme_mod('display_title_and_tagline') ? true : false);

        }

	}

    if (!class_exists('ofttoCommon')) {

        require_once(dirname(__FILE__) . '/includes/class-oftto-common.php');

    }

    if (get_template() == 'twentytwentyone') {

	    $options_for_twenty_twenty_one_object = new options_for_twenty_twenty_one_class();

    } else {

        $themes = wp_get_themes();

        if (!isset($themes['twentytwentyone'])) {

            add_action('admin_notices', 'oftto_wrong_theme_notice');

        }

        add_action('after_setup_theme', 'oftto_is_theme_being_previewed');

    }

    function oftto_wrong_theme_notice() {

?>

<div class="notice notice-error">

<p><strong><?php _e('Options for Twenty Twenty-One Plugin Error', 'options-for-twenty-twenty-one'); ?></strong><br />
<?php
        printf(
            __('This plugin requires the default Wordpress theme Twenty Twenty-One to be active or live previewed in order to function. Your theme "%s" is not compatible.', 'options-for-twenty-twenty-one'),
            get_template()
        );
?>

<a href="<?= add_query_arg('search', 'twentytwentyone', admin_url('theme-install.php')); ?>" title="<?= __('Twenty Twenty-One', 'options-for-twenty-twenty-one'); ?>"><?php
        _e('Please install and activate or live preview the Twenty Twenty-One theme (or a child theme thereof)', 'options-for-twenty-twenty-one');
?></a>.</p>

</div>

<?php

    }

    function oftto_is_theme_being_previewed() {

        if (get_template() == 'twentytwentyone' && is_customize_preview()) {

            $options_for_twenty_twenty_one_object = new options_for_twenty_twenty_one_class();

        }

    }

}

?>
