(function($) {

    wp.customize.bind('ready', function() {

        wp.customize('logo_size', function(this_customizer_control) { initiate_show_value(this_customizer_control); });

        wp.customize('aligndefault_max_width', function(this_customizer_control) { initiate_show_value(this_customizer_control); });

        wp.customize('alignwide_max_width', function(this_customizer_control) { initiate_show_value(this_customizer_control); });

        wp.customize('header_padding_top', function(this_customizer_control) { initiate_show_value(this_customizer_control,
            'px', // postfix
            1, // multiplier
            1 // deductor
        ); });

        wp.customize('header_padding_bottom', function(this_customizer_control) { initiate_show_value(this_customizer_control,
            'px', // postfix
            1, // multiplier
            1 // deductor
        ); });

        wp.customize('nav_burger_icon_size', function(this_customizer_control) { initiate_show_value(this_customizer_control); });

        wp.customize('nav_desktop_font_size', function(this_customizer_control) { initiate_show_value(this_customizer_control,
            'rem', // postfix
            0.001 // multiplier
        ); });

        wp.customize('mobile_nav_breakpoint', function(this_customizer_control) { initiate_show_value(this_customizer_control,
            'px', // postfix
            1, // multiplier
            -481 // deductor
        ); });

        wp.customize('footer_margin_top', function(this_customizer_control) { initiate_show_value(this_customizer_control,
            'px', // postfix
            1, // multiplier
            1 // deductor
        ); });

        wp.customize('footer_border_top', function(this_customizer_control) { initiate_show_value(this_customizer_control,
            'px', // postfix
            1, // multiplier
            1 // deductor
        ); });

        wp.customize('social_links_icon_size', function(this_customizer_control) { initiate_show_value(this_customizer_control); });

        function initiate_show_value(customizer_control, value_postfix = 'px', value_multiplier = 1, value_deductor = 0) {
            show_value(wp.customize(customizer_control.id).get(), customizer_control.id, value_postfix, value_multiplier, value_deductor);
            show_value_bind(customizer_control, value_postfix, value_multiplier, value_deductor);
        }

        function show_value_bind(customizer_control, value_postfix, value_multiplier, value_deductor) {
            customizer_control.bind(function(value) {
                show_value(value, customizer_control.id, value_postfix, value_multiplier, value_deductor);
            });
        }

        function show_value(value, control_name, value_postfix, value_multiplier, value_deductor) {
            if ($('#_customize-description-' + control_name + '-value').length) {
                $('#_customize-description-' + control_name + '-value').text(parseFloat(((value - value_deductor) * value_multiplier).toFixed(3)) + value_postfix);
            } else {
                $('#_customize-description-' + control_name + '').append($('<br /><strong id="_customize-description-' + control_name + '-value">' + parseFloat(((value - value_deductor) * value_multiplier).toFixed(3)) + value_postfix + '</strong>'));
            }
        }

    });

})(jQuery);
